package org.kodein.emoji.symbols.zodiac

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Gemini: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♊",
        description = "Gemini",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("gemini", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Symbols: zodiac: Gemini.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Gemini: Emoji get() = _Gemini
