package org.kodein.emoji.travel_places.place_building

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BuildingConstruction: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🏗️",
        description = "building construction",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("building-construction", "construction-building"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-building: building construction.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BuildingConstruction: Emoji get() = _BuildingConstruction

/**
 * Alias to emoji [BuildingConstruction] (Travel & Places: place-building: building construction).
*/
public val Emoji.Companion.ConstructionBuilding: Emoji get() = _BuildingConstruction
