package org.kodein.emoji.travel_places.place_map

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GlobeShowingAsiaAustralia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌏",
        description = "globe showing Asia-Australia",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("globe-showing-asia-australia", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: place-map: globe showing Asia-Australia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GlobeShowingAsiaAustralia: Emoji get() = _GlobeShowingAsiaAustralia
