package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RailwayTrack: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🛤️",
        description = "railway track",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("railway-track", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: railway track.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RailwayTrack: Emoji get() = _RailwayTrack
