package org.kodein.emoji

import org.kodein.emoji.smileys_emotion.*
import org.kodein.emoji.people_body.*
import org.kodein.emoji.animals_nature.*
import org.kodein.emoji.food_drink.*
import org.kodein.emoji.travel_places.*
import org.kodein.emoji.activities.*
import org.kodein.emoji.objects.*
import org.kodein.emoji.symbols.*
import org.kodein.emoji.flags.*


internal fun EmojiFinder.addAllEmoji() {
    addAllSmileysEmotion()
    addAllPeopleBody()
    addAllAnimalsNature()
    addAllFoodDrink()
    addAllTravelPlaces()
    addAllActivities()
    addAllObjects()
    addAllSymbols()
    addAllFlags()
}

internal val emojiCount get() = 1914
internal val emojiAliasCount get() = 2754
internal val emojiEmoticonCount get() = 112

/**
 * All known Emoji.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.sequence(): Sequence<Emoji> =
    sequence {
        yieldAllSmileysEmotion()
        yieldAllPeopleBody()
        yieldAllAnimalsNature()
        yieldAllFoodDrink()
        yieldAllTravelPlaces()
        yieldAllActivities()
        yieldAllObjects()
        yieldAllSymbols()
        yieldAllFlags()
    }

internal fun allEmojiGroups(): Map<String, Map<String, () -> List<Emoji>>> =
    mapOf(
        "smileys_emotion" to allSmileysEmotionSubgroups(),
        "people_body" to allPeopleBodySubgroups(),
        "animals_nature" to allAnimalsNatureSubgroups(),
        "food_drink" to allFoodDrinkSubgroups(),
        "travel_places" to allTravelPlacesSubgroups(),
        "activities" to allActivitiesSubgroups(),
        "objects" to allObjectsSubgroups(),
        "symbols" to allSymbolsSubgroups(),
        "flags" to allFlagsSubgroups(),
    )

public fun Emoji.Companion.list(): List<Emoji> =
    ArrayList<Emoji>(emojiCount).also { list -> sequence().forEach { list.add(it) } }

@Deprecated("Renamed list.", replaceWith = ReplaceWith("list()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.all(): List<Emoji> = list()
