package org.kodein.emoji.activities.award_medal

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SecondPlaceMedal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥈",
        description = "2nd place medal",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("2nd-place-medal", "silver-medal"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Activities: award-medal: 2nd place medal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SecondPlaceMedal: Emoji get() = _SecondPlaceMedal

/**
 * Alias to emoji [SecondPlaceMedal] (Activities: award-medal: 2nd place medal).
*/
public val Emoji.Companion.SilverMedal: Emoji get() = _SecondPlaceMedal
