package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WrappedGift: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎁",
        description = "wrapped gift",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("wrapped-gift", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Activities: event: wrapped gift.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WrappedGift: Emoji get() = _WrappedGift
