package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUruguay: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇺🇾",
        description = "flag: Uruguay",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-uruguay", "uruguay-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Uruguay.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUruguay: Emoji get() = _FlagUruguay

/**
 * Alias to emoji [FlagUruguay] (Flags: country-flag: flag: Uruguay).
*/
public val Emoji.Companion.UruguayFlag: Emoji get() = _FlagUruguay
