package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BeverageBox: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧃",
        description = "beverage box",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("beverage-box", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: beverage box.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BeverageBox: Emoji get() = _BeverageBox
