package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClinkingGlasses: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥂",
        description = "clinking glasses",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("clinking-glasses", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: clinking glasses.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClinkingGlasses: Emoji get() = _ClinkingGlasses
