package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FoldingHandFan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪭",
        description = "folding hand fan",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("folding-hand-fan", "fan"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: clothing: folding hand fan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FoldingHandFan: Emoji get() = _FoldingHandFan

/**
 * Alias to emoji [FoldingHandFan] (Objects: clothing: folding hand fan).
*/
public val Emoji.Companion.Fan: Emoji get() = _FoldingHandFan
