package org.kodein.emoji.objects.lock

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Unlocked: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔓",
        description = "unlocked",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("unlocked", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: lock: unlocked.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Unlocked: Emoji get() = _Unlocked
