package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ControlKnobs: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎛️",
        description = "control knobs",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("control-knobs", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: music: control knobs.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ControlKnobs: Emoji get() = _ControlKnobs
