package org.kodein.emoji.objects.science

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllScience() {
    add(intArrayOf(0x2697, 0xfe0f), _Alembic)
    add(intArrayOf(0x2697), _Alembic)
    add(intArrayOf(0x1f9ea), _TestTube)
    add(intArrayOf(0x1f9eb), _PetriDish)
    add(intArrayOf(0x1f9ec), _Dna)
    add(intArrayOf(0x1f52c), _Microscope)
    add(intArrayOf(0x1f52d), _Telescope)
    add(intArrayOf(0x1f4e1), _SatelliteAntenna)
}

internal suspend fun SequenceScope<Emoji>.yieldAllScience() {
    yield(_Alembic)
    yield(_TestTube)
    yield(_PetriDish)
    yield(_Dna)
    yield(_Microscope)
    yield(_Telescope)
    yield(_SatelliteAntenna)
}

internal val countScience = 7

/**
 * All Emoji of the Objects: science subgroup.
*/
public fun Emoji.Companion.sequenceScience(): Sequence<Emoji> =
    sequence { yieldAllScience() }

/**
 * All Emoji of the Objects: science subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listScience(): List<Emoji> =
    ArrayList<Emoji>(countScience).also { list -> sequenceScience().forEach { list.add(it) } }

@Deprecated("Renamed listScience.", replaceWith = ReplaceWith("listScience()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allScience(): List<Emoji> =
    listScience()
