package org.kodein.emoji.people_body.hand_fingers_closed

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _LeftFacingFist: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🤛",
        description = "left-facing fist",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("left-facing-fist", "fist-leftwards"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-fingers-closed: left-facing fist.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LeftFacingFist: SkinTone1Emoji get() = _LeftFacingFist

/**
 * Alias to emoji [LeftFacingFist] (People & Body: hand-fingers-closed: left-facing fist).
*/
public val Emoji.Companion.FistLeftwards: SkinTone1Emoji get() = _LeftFacingFist
