package org.kodein.emoji.people_body.person_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonSymbol() {
    add(intArrayOf(0x1f5e3, 0xfe0f), _SpeakingHead)
    add(intArrayOf(0x1f5e3), _SpeakingHead)
    add(intArrayOf(0x1f464), _BustInSilhouette)
    add(intArrayOf(0x1f465), _BustsInSilhouette)
    add(intArrayOf(0x1fac2), _PeopleHugging)
    add(intArrayOf(0x1f46a), _Family)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d1, 0x200d, 0x1f9d2), _FamilyAdultAdultChild)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d1, 0x200d, 0x1f9d2, 0x200d, 0x1f9d2), _FamilyAdultAdultChildChild)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d2), _FamilyAdultChild)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d2, 0x200d, 0x1f9d2), _FamilyAdultChildChild)
    add(intArrayOf(0x1f463), _Footprints)
    add(intArrayOf(0x1fac6), _Fingerprint)
}

internal suspend fun SequenceScope<Emoji>.yieldAllPersonSymbol() {
    yield(_SpeakingHead)
    yield(_BustInSilhouette)
    yield(_BustsInSilhouette)
    yield(_PeopleHugging)
    yield(_Family)
    yield(_FamilyAdultAdultChild)
    yield(_FamilyAdultAdultChildChild)
    yield(_FamilyAdultChild)
    yield(_FamilyAdultChildChild)
    yield(_Footprints)
    yield(_Fingerprint)
}

internal val countPersonSymbol = 11

/**
 * All Emoji of the People & Body: person-symbol subgroup.
*/
public fun Emoji.Companion.sequencePersonSymbol(): Sequence<Emoji> =
    sequence { yieldAllPersonSymbol() }

/**
 * All Emoji of the People & Body: person-symbol subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listPersonSymbol(): List<Emoji> =
    ArrayList<Emoji>(countPersonSymbol).also { list -> sequencePersonSymbol().forEach { list.add(it) } }

@Deprecated("Renamed listPersonSymbol.", replaceWith = ReplaceWith("listPersonSymbol()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allPersonSymbol(): List<Emoji> =
    listPersonSymbol()
