package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DistortedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫪",
        description = "distorted face",
        unicodeVersion = UnicodeVersion(17, 0),
        aliases = listOf("distorted-face", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: distorted face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DistortedFace: Emoji get() = _DistortedFace
