package org.kodein.emoji.smileys_emotion.face_costume

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClownFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤡",
        description = "clown face",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("clown-face", "clown"),
        emoticons = listOf(":o)"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-costume: clown face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClownFace: Emoji get() = _ClownFace

/**
 * Alias to emoji [ClownFace] (Smileys & Emotion: face-costume: clown face).
*/
public val Emoji.Companion.Clown: Emoji get() = _ClownFace
