package org.kodein.emoji.smileys_emotion.face_sleepy

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SleepingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😴",
        description = "sleeping face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("sleeping-face", "sleep"),
        emoticons = listOf("Z_Z"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-sleepy: sleeping face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SleepingFace: Emoji get() = _SleepingFace

/**
 * Alias to emoji [SleepingFace] (Smileys & Emotion: face-sleepy: sleeping face).
*/
public val Emoji.Companion.Sleep: Emoji get() = _SleepingFace
