package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NauseatedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤢",
        description = "nauseated face",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("nauseated-face", "sick", "nauseated"),
        emoticons = listOf(":-###"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: nauseated face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NauseatedFace: Emoji get() = _NauseatedFace

/**
 * Alias to emoji [NauseatedFace] (Smileys & Emotion: face-unwell: nauseated face).
*/
public val Emoji.Companion.Sick: Emoji get() = _NauseatedFace

/**
 * Alias to emoji [NauseatedFace] (Smileys & Emotion: face-unwell: nauseated face).
*/
public val Emoji.Companion.Nauseated: Emoji get() = _NauseatedFace
