package org.kodein.emoji.symbols

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.symbols.transport_sign.*
import org.kodein.emoji.symbols.warning.*
import org.kodein.emoji.symbols.arrow.*
import org.kodein.emoji.symbols.religion.*
import org.kodein.emoji.symbols.zodiac.*
import org.kodein.emoji.symbols.av_symbol.*
import org.kodein.emoji.symbols.gender.*
import org.kodein.emoji.symbols.math.*
import org.kodein.emoji.symbols.punctuation.*
import org.kodein.emoji.symbols.currency.*
import org.kodein.emoji.symbols.other_symbol.*
import org.kodein.emoji.symbols.keycap.*
import org.kodein.emoji.symbols.alphanum.*
import org.kodein.emoji.symbols.geometric.*


internal fun EmojiFinder.addAllSymbols() {
    addAllTransportSign()
    addAllWarning()
    addAllArrow()
    addAllReligion()
    addAllZodiac()
    addAllAvSymbol()
    addAllGender()
    addAllMath()
    addAllPunctuation()
    addAllCurrency()
    addAllOtherSymbol()
    addAllKeycap()
    addAllAlphanum()
    addAllGeometric()
}

internal suspend fun SequenceScope<Emoji>.yieldAllSymbols() {
    yieldAllTransportSign()
    yieldAllWarning()
    yieldAllArrow()
    yieldAllReligion()
    yieldAllZodiac()
    yieldAllAvSymbol()
    yieldAllGender()
    yieldAllMath()
    yieldAllPunctuation()
    yieldAllCurrency()
    yieldAllOtherSymbol()
    yieldAllKeycap()
    yieldAllAlphanum()
    yieldAllGeometric()
}

internal val countSymbols = 224

/**
 * All Emoji of the Symbols group.
*/
public fun Emoji.Companion.sequenceSymbols(): Sequence<Emoji> =
    sequence { yieldAllSymbols() }

/**
 * All Emoji of the Symbols group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allSymbols(): List<Emoji> =
    ArrayList<Emoji>(countSymbols).also { list -> sequenceSymbols().forEach { list.add(it) } }

internal fun allSymbolsSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "transport_sign" to { Emoji.listTransportSign() },
        "warning" to { Emoji.listWarning() },
        "arrow" to { Emoji.listArrow() },
        "religion" to { Emoji.listReligion() },
        "zodiac" to { Emoji.listZodiac() },
        "av_symbol" to { Emoji.listAvSymbol() },
        "gender" to { Emoji.listGender() },
        "math" to { Emoji.listMath() },
        "punctuation" to { Emoji.listPunctuation() },
        "currency" to { Emoji.listCurrency() },
        "other_symbol" to { Emoji.listOtherSymbol() },
        "keycap" to { Emoji.listKeycap() },
        "alphanum" to { Emoji.listAlphanum() },
        "geometric" to { Emoji.listGeometric() },
    )
