package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllKeycap() {
    add(intArrayOf(0x23, 0xfe0f, 0x20e3), _KeycapHash)
    add(intArrayOf(0x23, 0x20e3), _KeycapHash)
    add(intArrayOf(0x2a, 0xfe0f, 0x20e3), _KeycapStar)
    add(intArrayOf(0x2a, 0x20e3), _KeycapStar)
    add(intArrayOf(0x30, 0xfe0f, 0x20e3), _Keycap0)
    add(intArrayOf(0x30, 0x20e3), _Keycap0)
    add(intArrayOf(0x31, 0xfe0f, 0x20e3), _Keycap1)
    add(intArrayOf(0x31, 0x20e3), _Keycap1)
    add(intArrayOf(0x32, 0xfe0f, 0x20e3), _Keycap2)
    add(intArrayOf(0x32, 0x20e3), _Keycap2)
    add(intArrayOf(0x33, 0xfe0f, 0x20e3), _Keycap3)
    add(intArrayOf(0x33, 0x20e3), _Keycap3)
    add(intArrayOf(0x34, 0xfe0f, 0x20e3), _Keycap4)
    add(intArrayOf(0x34, 0x20e3), _Keycap4)
    add(intArrayOf(0x35, 0xfe0f, 0x20e3), _Keycap5)
    add(intArrayOf(0x35, 0x20e3), _Keycap5)
    add(intArrayOf(0x36, 0xfe0f, 0x20e3), _Keycap6)
    add(intArrayOf(0x36, 0x20e3), _Keycap6)
    add(intArrayOf(0x37, 0xfe0f, 0x20e3), _Keycap7)
    add(intArrayOf(0x37, 0x20e3), _Keycap7)
    add(intArrayOf(0x38, 0xfe0f, 0x20e3), _Keycap8)
    add(intArrayOf(0x38, 0x20e3), _Keycap8)
    add(intArrayOf(0x39, 0xfe0f, 0x20e3), _Keycap9)
    add(intArrayOf(0x39, 0x20e3), _Keycap9)
    add(intArrayOf(0x1f51f), _Keycap10)
}

internal suspend fun SequenceScope<Emoji>.yieldAllKeycap() {
    yield(_KeycapHash)
    yield(_KeycapStar)
    yield(_Keycap0)
    yield(_Keycap1)
    yield(_Keycap2)
    yield(_Keycap3)
    yield(_Keycap4)
    yield(_Keycap5)
    yield(_Keycap6)
    yield(_Keycap7)
    yield(_Keycap8)
    yield(_Keycap9)
    yield(_Keycap10)
}

internal val countKeycap = 13

/**
 * All Emoji of the Symbols: keycap subgroup.
*/
public fun Emoji.Companion.sequenceKeycap(): Sequence<Emoji> =
    sequence { yieldAllKeycap() }

/**
 * All Emoji of the Symbols: keycap subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listKeycap(): List<Emoji> =
    ArrayList<Emoji>(countKeycap).also { list -> sequenceKeycap().forEach { list.add(it) } }

@Deprecated("Renamed listKeycap.", replaceWith = ReplaceWith("listKeycap()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allKeycap(): List<Emoji> =
    listKeycap()
