package org.kodein.emoji.travel_places

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.travel_places.place_map.*
import org.kodein.emoji.travel_places.place_geographic.*
import org.kodein.emoji.travel_places.place_building.*
import org.kodein.emoji.travel_places.place_religious.*
import org.kodein.emoji.travel_places.place_other.*
import org.kodein.emoji.travel_places.transport_ground.*
import org.kodein.emoji.travel_places.transport_water.*
import org.kodein.emoji.travel_places.transport_air.*
import org.kodein.emoji.travel_places.hotel.*
import org.kodein.emoji.travel_places.time.*
import org.kodein.emoji.travel_places.sky_weather.*


internal fun EmojiFinder.addAllTravelPlaces() {
    addAllPlaceMap()
    addAllPlaceGeographic()
    addAllPlaceBuilding()
    addAllPlaceReligious()
    addAllPlaceOther()
    addAllTransportGround()
    addAllTransportWater()
    addAllTransportAir()
    addAllHotel()
    addAllTime()
    addAllSkyWeather()
}

internal suspend fun SequenceScope<Emoji>.yieldAllTravelPlaces() {
    yieldAllPlaceMap()
    yieldAllPlaceGeographic()
    yieldAllPlaceBuilding()
    yieldAllPlaceReligious()
    yieldAllPlaceOther()
    yieldAllTransportGround()
    yieldAllTransportWater()
    yieldAllTransportAir()
    yieldAllHotel()
    yieldAllTime()
    yieldAllSkyWeather()
}

internal val countTravelPlaces = 219

/**
 * All Emoji of the Travel & Places group.
*/
public fun Emoji.Companion.sequenceTravelPlaces(): Sequence<Emoji> =
    sequence { yieldAllTravelPlaces() }

/**
 * All Emoji of the Travel & Places group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allTravelPlaces(): List<Emoji> =
    ArrayList<Emoji>(countTravelPlaces).also { list -> sequenceTravelPlaces().forEach { list.add(it) } }

internal fun allTravelPlacesSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "place_map" to { Emoji.listPlaceMap() },
        "place_geographic" to { Emoji.listPlaceGeographic() },
        "place_building" to { Emoji.listPlaceBuilding() },
        "place_religious" to { Emoji.listPlaceReligious() },
        "place_other" to { Emoji.listPlaceOther() },
        "transport_ground" to { Emoji.listTransportGround() },
        "transport_water" to { Emoji.listTransportWater() },
        "transport_air" to { Emoji.listTransportAir() },
        "hotel" to { Emoji.listHotel() },
        "time" to { Emoji.listTime() },
        "sky_weather" to { Emoji.listSkyWeather() },
    )
