package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBahrain: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇭",
        description = "flag: Bahrain",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bahrain", "bahrain-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bahrain.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBahrain: Emoji get() = _FlagBahrain

/**
 * Alias to emoji [FlagBahrain] (Flags: country-flag: flag: Bahrain).
*/
public val Emoji.Companion.BahrainFlag: Emoji get() = _FlagBahrain
