package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCanada: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇦",
        description = "flag: Canada",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-canada", "canada-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Canada.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCanada: Emoji get() = _FlagCanada

/**
 * Alias to emoji [FlagCanada] (Flags: country-flag: flag: Canada).
*/
public val Emoji.Companion.CanadaFlag: Emoji get() = _FlagCanada
