package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagGuatemala: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇹",
        description = "flag: Guatemala",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-guatemala", "guatemala-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Guatemala.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagGuatemala: Emoji get() = _FlagGuatemala

/**
 * Alias to emoji [FlagGuatemala] (Flags: country-flag: flag: Guatemala).
*/
public val Emoji.Companion.GuatemalaFlag: Emoji get() = _FlagGuatemala
