package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagStBartheLemy: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇱",
        description = "flag: St. Barthélemy",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-st-barthe-lemy", "st-barthe-lemy-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: St. Barthélemy.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagStBartheLemy: Emoji get() = _FlagStBartheLemy

/**
 * Alias to emoji [FlagStBartheLemy] (Flags: country-flag: flag: St. Barthélemy).
*/
public val Emoji.Companion.StBartheLemyFlag: Emoji get() = _FlagStBartheLemy
