package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _BalletShoes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩰",
        description = "ballet shoes",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("ballet-shoes", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: ballet shoes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BalletShoes: Emoji get() = _BalletShoes
