package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EndArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔚",
        description = "END arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("end-arrow", "end", "arrow-end"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: END arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EndArrow: Emoji get() = _EndArrow

/**
 * Alias to emoji [EndArrow] (Symbols: arrow: END arrow).
*/
public val Emoji.Companion.End: Emoji get() = _EndArrow

/**
 * Alias to emoji [EndArrow] (Symbols: arrow: END arrow).
*/
public val Emoji.Companion.ArrowEnd: Emoji get() = _EndArrow
