package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SnowmanWithoutSnow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛄",
        description = "snowman without snow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("snowman-without-snow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: snowman without snow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SnowmanWithoutSnow: Emoji get() = _SnowmanWithoutSnow
