package org.kodein.emoji.activities.arts_crafts

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ArtistPalette: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎨",
        description = "artist palette",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("artist-palette", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: arts & crafts: artist palette.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ArtistPalette: Emoji get() = _ArtistPalette
