package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagDjibouti: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇩🇯",
        description = "flag: Djibouti",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-djibouti", "djibouti-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Djibouti.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagDjibouti: Emoji get() = _FlagDjibouti

/**
 * Alias to emoji [FlagDjibouti] (Flags: country-flag: flag: Djibouti).
*/
public val Emoji.Companion.DjiboutiFlag: Emoji get() = _FlagDjibouti
