package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLithuania: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇹",
        description = "flag: Lithuania",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-lithuania", "lithuania-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Lithuania.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLithuania: Emoji get() = _FlagLithuania

/**
 * Alias to emoji [FlagLithuania] (Flags: country-flag: flag: Lithuania).
*/
public val Emoji.Companion.LithuaniaFlag: Emoji get() = _FlagLithuania
