package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagStPierreMiquelon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇲",
        description = "flag: St. Pierre & Miquelon",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-st-pierre-miquelon", "st-pierre-miquelon-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: St. Pierre & Miquelon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagStPierreMiquelon: Emoji get() = _FlagStPierreMiquelon

/**
 * Alias to emoji [FlagStPierreMiquelon] (Flags: country-flag: flag: St. Pierre & Miquelon).
*/
public val Emoji.Companion.StPierreMiquelonFlag: Emoji get() = _FlagStPierreMiquelon
