package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTrinidadTobago: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇹",
        description = "flag: Trinidad & Tobago",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-trinidad-tobago", "trinidad-tobago-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Trinidad & Tobago.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTrinidadTobago: Emoji get() = _FlagTrinidadTobago

/**
 * Alias to emoji [FlagTrinidadTobago] (Flags: country-flag: flag: Trinidad & Tobago).
*/
public val Emoji.Companion.TrinidadTobagoFlag: Emoji get() = _FlagTrinidadTobago
