package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagWesternSahara: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇪🇭",
        description = "flag: Western Sahara",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-western-sahara", "western-sahara-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Western Sahara.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagWesternSahara: Emoji get() = _FlagWesternSahara

/**
 * Alias to emoji [FlagWesternSahara] (Flags: country-flag: flag: Western Sahara).
*/
public val Emoji.Companion.WesternSaharaFlag: Emoji get() = _FlagWesternSahara
