package org.kodein.emoji.people_body.hands

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _ClappingHands: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👏",
        description = "clapping hands",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("clapping-hands", "clap"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hands: clapping hands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClappingHands: SkinTone1Emoji get() = _ClappingHands

/**
 * Alias to emoji [ClappingHands] (People & Body: hands: clapping hands).
*/
public val Emoji.Companion.Clap: SkinTone1Emoji get() = _ClappingHands
