package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonStanding: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧍",
        description = "person standing",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("person-standing", "standing"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person standing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonStanding: SkinTone1Emoji get() = _PersonStanding

/**
 * Alias to emoji [PersonStanding] (People & Body: person-activity: person standing).
*/
public val Emoji.Companion.Standing: SkinTone1Emoji get() = _PersonStanding
