package org.kodein.emoji.people_body.person_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPersonSymbol() {
    add(intArrayOf(0x1fac2), _PeopleHugging)
    add(intArrayOf(0x1f465), _BustsInSilhouette)
    add(intArrayOf(0x1f464), _BustInSilhouette)
    add(intArrayOf(0x1f5e3, 0xfe0f), _SpeakingHead)
    add(intArrayOf(0x1f5e3), _SpeakingHead)
    add(intArrayOf(0x1f463), _Footprints)
    add(intArrayOf(0x1f46a), _Family)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d1, 0x200d, 0x1f9d2), _FamilyAdultAdultChild)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d1, 0x200d, 0x1f9d2, 0x200d, 0x1f9d2), _FamilyAdultAdultChildChild)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d2), _FamilyAdultChild)
    add(intArrayOf(0x1f9d1, 0x200d, 0x1f9d2, 0x200d, 0x1f9d2), _FamilyAdultChildChild)
}

internal fun MutableList<Emoji>.addAllPersonSymbol() {
    add(_PeopleHugging)
    add(_BustsInSilhouette)
    add(_BustInSilhouette)
    add(_SpeakingHead)
    add(_Footprints)
    add(_Family)
    add(_FamilyAdultAdultChild)
    add(_FamilyAdultAdultChildChild)
    add(_FamilyAdultChild)
    add(_FamilyAdultChildChild)
}

/**
 * All Emoji of the People & Body: person-symbol subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPersonSymbol(): List<Emoji> =
    ArrayList<Emoji>(10).apply { addAllPersonSymbol() }
