package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LightBlueHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🩵",
        description = "light blue heart",
        unicodeVersion = UnicodeVersion(15, 0),
        aliases = listOf("light-blue-heart", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: light blue heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LightBlueHeart: Emoji get() = _LightBlueHeart
