package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OnArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔛",
        description = "ON! arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("on-arrow", "on", "arrow-on"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: ON! arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OnArrow: Emoji get() = _OnArrow

/**
 * Alias to emoji [OnArrow] (Symbols: arrow: ON! arrow).
*/
public val Emoji.Companion.On: Emoji get() = _OnArrow

/**
 * Alias to emoji [OnArrow] (Symbols: arrow: ON! arrow).
*/
public val Emoji.Companion.ArrowOn: Emoji get() = _OnArrow
