package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RecordButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏺️",
        description = "record button",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("record-button", "record"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: av-symbol: record button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RecordButton: Emoji get() = _RecordButton

/**
 * Alias to emoji [RecordButton] (Symbols: av-symbol: record button).
*/
public val Emoji.Companion.Record: Emoji get() = _RecordButton
