package org.kodein.emoji.symbols.gender

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TransgenderSymbol: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⚧️",
        description = "transgender symbol",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("transgender-symbol", "trans-sign"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: gender: transgender symbol.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TransgenderSymbol: Emoji get() = _TransgenderSymbol

/**
 * Alias to emoji [TransgenderSymbol] (Symbols: gender: transgender symbol).
*/
public val Emoji.Companion.TransSign: Emoji get() = _TransgenderSymbol
