package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagRussia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇷🇺",
        description = "flag: Russia",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-russia", "russia-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Russia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagRussia: Emoji get() = _FlagRussia

/**
 * Alias to emoji [FlagRussia] (Flags: country-flag: flag: Russia).
*/
public val Emoji.Companion.RussiaFlag: Emoji get() = _FlagRussia
