package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonInSteamyRoom: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧖",
        description = "person in steamy room",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("person-in-steamy-room", "sauna", "steamy"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person in steamy room.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonInSteamyRoom: SkinTone1Emoji get() = _PersonInSteamyRoom

/**
 * Alias to emoji [PersonInSteamyRoom] (People & Body: person-activity: person in steamy room).
*/
public val Emoji.Companion.Sauna: SkinTone1Emoji get() = _PersonInSteamyRoom

/**
 * Alias to emoji [PersonInSteamyRoom] (People & Body: person-activity: person in steamy room).
*/
public val Emoji.Companion.Steamy: SkinTone1Emoji get() = _PersonInSteamyRoom
