package org.kodein.emoji.people_body.person_sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonMountainBiking: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🚵",
        description = "person mountain biking",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("person-mountain-biking", "mountain-biking"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-sport: person mountain biking.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonMountainBiking: SkinTone1Emoji get() = _PersonMountainBiking

/**
 * Alias to emoji [PersonMountainBiking] (People & Body: person-sport: person mountain biking).
*/
public val Emoji.Companion.MountainBiking: SkinTone1Emoji get() = _PersonMountainBiking
