package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeadShakingVertically: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🙂‍↕",
        description = "head shaking vertically",
        unicodeVersion = UnicodeVersion(15, 1),
        aliases = listOf("head-shaking-vertically", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: head shaking vertically.
 *
 * Preferred type is: minimally-qualified.
*/
public val Emoji.Companion.HeadShakingVertically: Emoji get() = _HeadShakingVertically
