package org.kodein.emoji.travel_places.place_other

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllPlaceOther() {
    add(intArrayOf(0x1f305), _Sunrise)
    add(intArrayOf(0x1f304), _SunriseOverMountains)
    add(intArrayOf(0x1f6dd), _PlaygroundSlide)
    add(intArrayOf(0x1f3a2), _RollerCoaster)
    add(intArrayOf(0x1f3a1), _FerrisWheel)
    add(intArrayOf(0x1f3a0), _CarouselHorse)
    add(intArrayOf(0x1f3aa), _CircusTent)
    add(intArrayOf(0x1f488), _BarberPole)
    add(intArrayOf(0x26f2), _Fountain)
    add(intArrayOf(0x26fa), _Tent)
    add(intArrayOf(0x1f3d9, 0xfe0f), _Cityscape)
    add(intArrayOf(0x1f3d9), _Cityscape)
    add(intArrayOf(0x1f306), _CityscapeAtDusk)
    add(intArrayOf(0x1f307), _Sunset)
    add(intArrayOf(0x1f303), _NightWithStars)
    add(intArrayOf(0x1f309), _BridgeAtNight)
    add(intArrayOf(0x1f301), _Foggy)
    add(intArrayOf(0x2668, 0xfe0f), _HotSprings)
    add(intArrayOf(0x2668), _HotSprings)
}

internal fun MutableList<Emoji>.addAllPlaceOther() {
    add(_Sunrise)
    add(_SunriseOverMountains)
    add(_PlaygroundSlide)
    add(_RollerCoaster)
    add(_FerrisWheel)
    add(_CarouselHorse)
    add(_CircusTent)
    add(_BarberPole)
    add(_Fountain)
    add(_Tent)
    add(_Cityscape)
    add(_CityscapeAtDusk)
    add(_Sunset)
    add(_NightWithStars)
    add(_BridgeAtNight)
    add(_Foggy)
    add(_HotSprings)
}

/**
 * All Emoji of the Travel & Places: place-other subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allPlaceOther(): List<Emoji> =
    ArrayList<Emoji>(17).apply { addAllPlaceOther() }
