package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DiamondSuit: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♦️",
        description = "diamond suit",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("diamond-suit", "diamond"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: game: diamond suit.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DiamondSuit: Emoji get() = _DiamondSuit

/**
 * Alias to emoji [DiamondSuit] (Activities: game: diamond suit).
*/
public val Emoji.Companion.Diamond: Emoji get() = _DiamondSuit
