package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagFrenchSouthernTerritories: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇫",
        description = "flag: French Southern Territories",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-french-southern-territories", "french-southern-territories-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: French Southern Territories.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagFrenchSouthernTerritories: Emoji get() = _FlagFrenchSouthernTerritories

/**
 * Alias to emoji [FlagFrenchSouthernTerritories] (Flags: country-flag: flag: French Southern Territories).
*/
public val Emoji.Companion.FrenchSouthernTerritoriesFlag: Emoji get() = _FlagFrenchSouthernTerritories
